% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visNetworkEditor.R
\name{visNetworkEditor-module}
\alias{visNetworkEditor-module}
\alias{visNetworkEditorServer}
\alias{visNetworkEditorUI}
\title{Module shiny for visualize and customize and get back a \code{visNetwork} object.
Using the javascript interface \link{visConfigure}.}
\usage{
visNetworkEditorServer(
  input,
  output,
  session,
  object,
  filter = shiny::reactive(NULL),
  showButton = shiny::reactive(NULL)
)

visNetworkEditorUI(id, quitButton = FALSE, height = "700px")
}
\arguments{
\item{input}{\code{list} shiny input}

\item{output}{\code{list}, shiny output}

\item{session}{\code{list}, shiny session}

\item{object}{a \code{visNetwork} object. Must be a reactive.}

\item{filter}{: see \link{visConfigure}. Must be a reactive.}

\item{showButton}{: see \link{visConfigure}. Must be a reactive.}

\item{id}{\code{character} id of module, linked to  \link{visNetworkEditorUI}}

\item{quitButton}{: logical. Add a button for quit shiny and get back network in R ?}

\item{height}{: height of the configuration div. Defaut to "700px"}
}
\description{
Module shiny for visualize and customize and get back a \code{visNetwork} object.
Using the javascript interface \link{visConfigure}.
}
\examples{
\dontrun{

nodes <- data.frame(id = 1:3, label = paste("Node", 1:3))
edges <- data.frame(from = c(1,2), to = c(1,3), label = paste("Edge", 1:2))
network <- visNetwork(nodes, edges)

shiny::shinyApp(ui = shiny::fluidPage(
 visNetworkEditorUI(id = "id1")), 
 server = function(input, output, session) {
 shiny::callModule(visNetworkEditorServer, "id1", object = shiny::reactive(network))
})

}
}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visConfigure}, \link{visTree}, \link{visNetworkEditor}
}
