% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/visFocus.R
\name{visFocus}
\alias{visFocus}
\title{Network visualization focus method}
\usage{
visFocus(graph, id, scale = 2, offset = list(x = 0, y = 0), locked = TRUE,
  animation = list(duration = 1500, easingFunction = "easeInOutQuad"))
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{id}{: a node id}

\item{scale}{: Optional. Number. The scale is the target zoomlevel. Default value is 2.0.}

\item{offset}{: Optional. List. The offset (in DOM units) is how many pixels from the center the view is focussed. Default value is list(x = 0, y = 0).}

\item{locked}{: Optional. Boolean. Locked denotes whether or not the view remains locked to the node once the zoom-in animation is finished. Default value is true.}

\item{animation}{: Optional. List. For animation you can define the duration (in milliseconds) and easing function manually.
Available are: linear, easeInQuad, easeOutQuad, easeInOutQuad, easeInCubic, easeOutCubic, easeInOutCubic, easeInQuart, easeOutQuart, easeInOutQuart, easeInQuint, easeOutQuint, easeInOutQuint.
Default to list(duration = 1500, easingFunction = "easeInOutQuad")}
}
\description{
Network visualization focus method For use focus() method in a shiny app. For full documentation, have a look at \link{visDocumentation}.
}
\examples{
\dontrun{

# have a look to :
shiny::runApp(system.file("shiny", package = "visNetwork"))

}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options,
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout,
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}

