% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viralmodels-package.R
\docType{package}
\name{viralmodels-package}
\alias{viralmodels}
\alias{viralmodels-package}
\title{viralmodels: Viral Load and CD4 Lymphocytes Regression Models}
\description{
Provides a comprehensive framework for building, evaluating, and visualizing regression models for analyzing viral load and CD4 (Cluster of Differentiation 4) lymphocytes data. It leverages the principles of the tidymodels ecosystem of Max Kuhn and Hadley Wickham (2020) \url{https://www.tidymodels.org} to offer a user-friendly experience in model development. This package includes functions for data preprocessing, feature engineering, model training, tuning, and evaluation, along with visualization tools to enhance the interpretation of model results. It is specifically designed for researchers in biostatistics, computational biology, and HIV research who aim to perform reproducible and rigorous analyses to gain insights into disease dynamics. The main focus is on improving the understanding of the relationships between viral load, CD4 lymphocytes, and other relevant covariates to contribute to HIV research and the visibility of vulnerable seropositive populations.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/juanv66x/viralmodels}
  \item Report bugs at \url{https://github.com/juanv66x/viralmodels/issues}
}

}
\author{
\strong{Maintainer}: Juan Pablo Acuña González \email{acua6307@gmail.com} (\href{https://orcid.org/0009-0003-6029-6560}{ORCID})

}
\keyword{internal}
