% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hessian3D.R
\name{hessian3D}
\alias{hessian3D}
\title{3D Volume Hessian}
\usage{
hessian3D(image, mask, radius = 1, parallel = FALSE, cores = 2)
}
\arguments{
\item{image}{a 3D array or image of class \code{\link{nifti}}}

\item{mask}{an array or \code{\link{nifti}} mask of voxels for which vesselness will be calculated,
with more selective masking improving speed significantly.
Note that mask should be in the same space as the image volume}

\item{radius}{an integer specifying radius of the neighborhood (in voxels) for which the hessian should be calculated}

\item{parallel}{is a logical value that indicates whether the user's computer
is Linux or Unix (i.e. macOS), and should run the code in parallel}

\item{cores}{if parallel = TRUE, cores is an integer value that indicates how many cores
the function should be run on}
}
\value{
A list of three eigenvalue volumes.
}
\description{
This function returns the eigenvalues of the hessian matrices for a 3D array or NIfTI volume.
}
\examples{
\dontrun{
library(neurobase)
epi <- readnii('path/to/epi')
mask <- epi!=0
hesseigs <- hessian3D(image = epi, mask = mask) }
}
