% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_misc.R
\name{meta.ave.fisher}
\alias{meta.ave.fisher}
\title{Fisher confidence interval for an average correlation.}
\usage{
meta.ave.fisher(alpha, cor, se)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{cor}{estimate of average correlation}

\item{se}{standard error of average correlation}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of average correlation (from input)
\item LL - lower limit of the confidence interval
\item UL - lower limit of the confidence interval
}
}
\description{
This function should be used with the \link[vcmeta]{meta.ave.gen}
function when the effect size is a correlation. Use the estimated average
correlation and its standard error from meta.ave.gen in this function to
obtain a more accurate confidence interval for the population average
correlation.
}
\examples{
meta.ave.fisher(0.05, 0.376, .054)

# Should return:
# Estimate        LL        UL
#    0.376 0.2656039 0.4766632


}
