% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{v_event}
\alias{v_event}
\title{VChart events}
\usage{
v_event(vc, name, params, fun, ...)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{name}{Name of the event, e.g. \code{"click"}.}

\item{params}{Parameters to specifically monitor events in a certain part of the chart.}

\item{fun}{JavaScript function executed when the event occurs.}

\item{...}{Not used.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
VChart events
}
\examples{

library(vchartr)

vchart(top_generation) \%>\% 
  v_bar(aes(country, electricity_generation)) \%>\% 
  v_event(
    name = "click",
    params = list(level = "mark", type = "bar"),
    fun = JS(
      "e => {",
      " console.log(e);",
      " alert(e.datum.x);",
      "}"
    )
  )

}
