% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_legend_with_brackets.R
\name{draw_legend_with_brackets}
\alias{draw_legend_with_brackets}
\title{Create a custom legend with vertical brackets}
\usage{
draw_legend_with_brackets(
  labels,
  colors,
  comparisons = NULL,
  x = 0.1,
  y = 0.9,
  width = 0.2,
  height = NULL,
  title = NULL,
  text_size = 10,
  text_family = "sans",
  text_face = "plain",
  title_size = 11,
  title_face = "bold",
  sig_size = 11,
  sig_face = "plain",
  output_width = NULL,
  output_height = NULL
)
}
\arguments{
\item{labels}{Character vector of group names}

\item{colors}{Character vector of colors for each group}

\item{comparisons}{Data frame with columns: group1, group2, label}

\item{x}{Numeric. X position of legend (0-1, in npc units)}

\item{y}{Numeric. Y position of legend (0-1, in npc units)}

\item{width}{Numeric. Width of legend box}

\item{height}{Numeric. Height of legend box}

\item{title}{Character. Legend title (optional)}

\item{text_size}{Numeric. Font size for legend labels (default 10)}

\item{text_family}{Character. Font family (e.g., "sans", "serif", "mono", "Helvetica", "Times")}

\item{text_face}{Character. Font face: "plain", "bold", "italic", "bold.italic" (default "plain")}

\item{title_size}{Numeric. Font size for title (default 11)}

\item{title_face}{Character. Font face for title (default "bold")}

\item{sig_size}{Numeric. Font size for significance symbols (default 11)}

\item{sig_face}{Character. Font face for significance symbols (default "plain")}

\item{output_width}{Numeric. Output figure width in inches (optional, for METHOD 2)}

\item{output_height}{Numeric. Output figure height in inches (optional, for METHOD 2)}
}
\value{
A gTree object containing the custom legend
}
\description{
This function draws a completely custom legend outside of ggplot2's system,
with vertical brackets showing comparisons.
}
\examples{
\donttest{
labels <- c("WT", "WT/Dox", "CH3+5")
colors <- c("green", "orange", "blue")
comps <- data.frame(group1 = "WT", group2 = "WT/Dox", label = "*")
legend_grob <- draw_legend_with_brackets(labels, colors, comps,
                                         text_family = "sans",
                                         text_size = 12)
grid::grid.draw(legend_grob)
}
}
