% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_subset.R
\name{vascr_subset}
\alias{vascr_subset}
\title{Subset a vascr data set based on a number of factors}
\usage{
vascr_subset(
  data.df,
  time = NULL,
  unit = NULL,
  well = NULL,
  frequency = NULL,
  experiment = NULL,
  instrument = NULL,
  sampleid = NULL,
  sample = NULL,
  subsample = NULL,
  remove_na_value = TRUE,
  remove_excluded = TRUE
)
}
\arguments{
\item{data.df}{vascr data set to subset}

\item{time}{Specified times. Individual values in a list will be subset out. If vectors are present in the list, values between the two most extreme values will be returned.}

\item{unit}{Units to subset. These are checked for integrity against possible units and the dataset itself}

\item{well}{Wells to select}

\item{frequency}{Frequencies to include in the data set.}

\item{experiment}{Experiments to include in the data set. Can be addressed either by name, or by the numerical order that they were loaded into vascr_combine in}

\item{instrument}{Which instruments to include values from}

\item{sampleid}{List of ID's to be used. Sample names will be re-ordered accordingly for display.}

\item{sample}{Sample to subset}

\item{subsample}{Frequency values should be sub-sampled to}

\item{remove_na_value}{Should NA values be removed (default true)}

\item{remove_excluded}{Should excluded values be removed (default true)}
}
\value{
The subset dataset, based on the values selected
}
\description{
Subset a vascr data set based on a number of factors
}
\examples{
vascr_subset(growth.df)
vascr_subset(growth.df, time = 40)
vascr_subset(growth.df, time = NULL)
 
vascr_subset(growth.df, unit = "Rb")
vascr_subset(growth.df, unit = "R")
vascr_subset(growth.df, well = "A1")

vascr_subset(growth.df, time = c(5,20))
}
