% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ow.anova.R
\name{ow.anova}
\alias{ow.anova}
\title{Simplified One-Way Analysis of Variance}
\usage{
ow.anova(df, var1, by1, plot = FALSE, hsd = FALSE)
}
\arguments{
\item{df}{data frame to read in.}

\item{var1}{the dependent/outcome variable, \eqn{Y}.}

\item{by1}{the main independent/predictor variable, \eqn{X}. A grouping variable by which \code{var1} should be parsed.}

\item{plot}{logical (default set to \code{F}). When set to \code{plot = T}, will return a means plot with 95 percent confidence intervals, broken out by each group (\code{by1}).}

\item{hsd}{logical (default set to \code{F}). When set to \code{hsd = T}, will return results of Tukey's Honestly Significant Difference Post-Hoc Comparisons Test.}
}
\value{
This function returns the summary results table for a one-way ANOVA, examining mean differences in \code{var1} from data frame \code{df}, across \code{by1} groups.
}
\description{
This function simplifies the call for one-way ANOVA (ow.anova) on a given data frame. Also allows calls for Tukey's Honestly Significant Difference Post-Hoc Comparisons Test (hsd), as well as a means plot (plot).
}
\examples{
data <- mtcars

ow <- ow.anova(data,mpg,cyl,plot=TRUE)
summary(ow)
}
