% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deming_methods.R
\name{print.deming_regression}
\alias{print.deming_regression}
\title{Print method for deming_regression objects}
\usage{
\method{print}{deming_regression}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{deming_regression}.}

\item{digits}{Number of significant digits to display (default: 3).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the input object.
}
\description{
Displays a concise summary of Deming regression results, including
slope and intercept estimates with confidence intervals.
}
\examples{
set.seed(42)
true_vals <- rnorm(50, 100, 20)
method_a <- true_vals + rnorm(50, sd = 5)
method_b <- 1.05 * true_vals + 3 + rnorm(50, sd = 5)
dm <- deming_regression(method_a, method_b)
print(dm)

}
\seealso{
\code{\link[=summary.deming_regression]{summary.deming_regression()}} for detailed output
}
