% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCLA.R
\docType{data}
\name{ucla_4}
\alias{ucla_4}
\title{Blue brand gradient colors of UCLA, University of California, Los Angeles, USA}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on \href{https://www.ucla.edu}{UCLA}'s 
\href{https://brand.ucla.edu/identity/colors}{Color manual}.
}
\usage{
ucla_4
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ucla_4} provides three blue brand gradient colors
of the \href{https://www.ucla.edu}{University of California, Los Angeles (UCLA)}, USA.
}
\details{
The 3 gradient colors are 
\code{darker blue}, defined as CMYK 100 45 0 45, RGB 0 85 135, or HEX #005587, 
\code{UCLA blue}, defined as CMYK 83 40 3 6, RGB 39 116 174, or HEX #2774AE, and 
\code{lighter blue}, defined as CMYK 45 14 0 0, RGB 139 184 232, or HEX #8BB8E8. 

\code{ucla_4} uses the HEX color definitions.


A blue gradient can be used to enliven fields of color.  

If the gradient is used strictly as a background -- for instance, under an overlay box --  
you can use the complete color range. 

If you are overprinting the gradient with type, you need to make sure the resulting 
contrast ratio meets accessibility standards. 
See the color combination chart at \url{https://brand.ucla.edu/identity/colors#accessibility}.
}
\examples{
ucla_4
unikn::seecol(ucla_4, main = "The blue gradient colors of UCLA")  # view color palette

# Gradient with n = 7 tints:
unikn::seecol(unikn::usecol(ucla_4, n = 7), main = "UCLA blue brand gradient")

}
\seealso{
\code{\link{ucla_1}} for primary colors of UCLA,; 
\code{\link{ucla_2}} for secondary colors of UCLA,;
\code{\link{ucla_3}} for tertiary colors of UCLA,; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-16.
}
\concept{U.S. university color palettes}
\keyword{datasets}
