% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ohio_Uni.R
\docType{data}
\name{ohio_uni_1}
\alias{ohio_uni_1}
\title{Primary colors of Ohio University, USA}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on OU's 
\href{https://www.ohio.edu/ucm/ohio-brand/colors}{color brand information}.
}
\usage{
ohio_uni_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{ohio_uni_1} provides the three primary colors 
of \href{https://www.ohio.edu}{Ohio University}, USA.
}
\details{
The 3 primary colors are 
\code{Cutler green} (defined as HEX \code{"#00694E"}), 
\code{Under the elms} (defined as HEX \code{"#024230"}), and 
\code{Cupola white} (defined as HEX \code{"#FFFFFF"} or \code{"white"}), 

\code{ohio_uni_1} uses the HEX color definitions. 

The primary color palette should be used across all brand communications. 

\code{Cutler green} should be the dominant color used 
while \code{Under the elms} and \code{Cupola white} can be used as an accent. 

Black and white are accent colors that can be used sparingly across all color palettes.
}
\examples{
ohio_uni_1
unikn::seecol(ohio_uni_1, col_bg = "lightgray", 
              main = "Primary colors of Ohio University")  # view color palette
unikn::demopal(ohio_uni_1, main = "Primary colors of Ohio University", 
               type = 2, seed = 1)  # demo color palette 

}
\seealso{
\code{\link{ohio_uni_2}} for secondary colors of Ohio University;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-08-28.
}
\concept{U.S. university color palettes}
\keyword{datasets}
