% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Michigan.R
\docType{data}
\name{michigan_2}
\alias{michigan_2}
\title{Secondary colors of the University of Michigan, USA}
\format{
An object of class \code{character} of length 13.
}
\source{
Color definitions are based on the
\href{https://brand.umich.edu/design-resources/colors/}{Color manual}.
}
\usage{
michigan_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{michigan_2} provides the 13 secondary colors
of the \href{https://umich.edu}{University of Michigan}, USA.
}
\details{
The colors in our supporting palette were chosen to complement our 
primary palette of maize and blue (see \code{\link{michigan_1}}), 
providing additional range to the brand experience.

They work well as secondary colors or as backgrounds behind typography or graphics, 
but should never replace the primary palette as the main color(s) of a design.

While these colors are recommended rather than mandated, 
we strongly encourage you to use them.

These secondary colors are 
\code{"tappan_red"} (defined as PMS 484, CMYK 8/92/100/33, HEX #9A3324),
\code{"ross_orange"} (defined as PMS 1595, CMYK 0/71/100/3, HEX #D86018),
\code{"rackham_green"} (defined as PMS 5565, CMYK 44/12/34/24, HEX #75988d),
\code{"wave_field_green"} (defined as PMS 398, CMYK 14/6/100/24, HEX #A5A508),
\code{"taubman_teal"} (defined as PMS 326, CMYK 81/0/39/0, HEX #00B2A9),
\code{"arboretum_blue"} (defined as PMS 660, CMYK 88/50/0/0, HEX #2F65A7),
\code{"a2_amethyst"} (defined as PMS 2603, CMYK 72/99/0/3, HEX #702082),
\code{"matthaei_violet"} (defined as PMS 668, CMYK 70/77/7/23, HEX #575294),
\code{"umma_tan"} (defined as PMS 7502, CMYK 6/14/39/8, HEX #CFC096),
\code{"burton_tower_beige"} (defined as PMS 451, CMYK 21/15/54/31, HEX #9B9A6D),
\code{"angell_hall_ash"} (defined as PMS PANTONE Warm Gray 6, CMYK 14/19/21/39, HEX #989C97),
\code{"law_quad_stone"} (defined as PMS PANTONE Warm Gray 11, CMYK 26/36/38/68, HEX #655A52), and
\code{"puma_black"} (defined as PMS PANTONE Black 6, CMYK 100/79/44/93, HEX #131516).
}
\examples{
michigan_2
unikn::seecol(michigan_2, main = "Secondary colors Michigan Uni") # view color palette

}
\seealso{
\code{\link{michigan_1}} for primary colors of the University of Michigan; 
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{manchester_uni_2}},
\code{\link{michigan_1}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-14.
}
\concept{U.S. university color palettes}
\keyword{datasets}
