% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Helsinki.R
\docType{data}
\name{helsinki_3}
\alias{helsinki_3}
\title{Departmental accent colors of the University of Helsinki, Finland}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
the \href{https://www.helsinki.fi}{UH}'s 
\href{https://static.helsinki.fi/ds/tokens/color.html}{brand guide} (HTML).
}
\usage{
helsinki_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{helsinki_3} provides the departmental accent colors 
of the \href{https://www.helsinki.fi}{University of Helsinki}, Finland.
}
\details{
Additional colors are used only as an accent color for different department's designs 
and should not be used in general components.

\code{helsinki_3} is based on HEX color definitions.
}
\examples{
helsinki_3
unikn::seecol(helsinki_3, 
              main = "Departmental accent colors of the University of Helsinki, Finland")

}
\seealso{
\code{\link{helsinki_1}} for main brand colors of the University of Helsinki;
\code{\link{helsinki_2}} for grayscale colors of the University of Helsinki;
\code{\link{seecol}} for viewing and comparing color palettes;
\code{\link{usecol}} for using color palettes;
\code{\link{simcol}} for finding similar colors;
\code{\link{newpal}} for defining new color palettes;
\code{\link{grepal}} for finding named colors.

Other Finnish university color palettes: 
\code{\link{aalto_1}},
\code{\link{aalto_2}},
\code{\link{helsinki_1}},
\code{\link{helsinki_2}}
}
\author{
\strong{unicol}, 2023-10-15.
}
\concept{Finnish university color palettes}
\keyword{datasets}
