% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload_caption.R
\name{upload_caption}
\alias{upload_caption}
\title{Upload Video Caption to Youtube}
\usage{
upload_caption(file, video_id, language = "en-US", caption_name,
  is_draft = FALSE, query = NULL, open_url = FALSE, ...)
}
\arguments{
\item{file}{Filename of the caption, probably `.srt`}

\item{video_id}{YouTube Video ID.  Try \code{\link{list_my_videos}} for examples.}

\item{language}{character string of `BCP47` language type.
See \url{http://www.rfc-editor.org/rfc/bcp/bcp47.txt} for language specification}

\item{caption_name}{character vector of the name for the caption.}

\item{is_draft}{logical indicating whether the caption track is a draft.}

\item{query}{Fields for `query` in `POST`}

\item{open_url}{Should the video be opened using \code{\link{browseURL}}}

\item{...}{Additional arguments to send to \code{\link{POST}}}
}
\value{
A list of the response object from the \code{POST}, content,
and the URL of the video
}
\description{
Upload Video Caption to Youtube
}
\note{
See
\url{https://developers.google.com/youtube/v3/docs/captions#resource} for
full specification
}
\examples{
\dontrun{
xx = list_my_videos()
video_id = xx$contentDetails.videoId[1]
video_id = as.character(video_id)
language = "en-US"
}
}
