% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_subscriptions.R
\name{get_subscriptions}
\alias{get_subscriptions}
\title{Get Subscriptions}
\usage{
get_subscriptions(filter = NULL, part = "contentDetails",
  max_results = 50, for_channel_id = NULL, order = NULL,
  page_token = NULL, ...)
}
\arguments{
\item{filter}{string; Required.
named vector of length 1
potential names of the entry in the vector: 
\code{channel_id}: ID of the channel. Required. No default.
\code{subscription_id}: YouTube subscription ID}

\item{part}{Part of the resource requested. Required. Character. 
A comma separated list of one or more of the following: \code{contentDetails, id, snippet, subscriberSnippet}. e.g. "id, snippet", "id", etc. Default: \code{contentDetails}.}

\item{max_results}{Maximum number of items that should be returned. Integer. Optional. Can be between 0 and 50. Default is 50.}

\item{for_channel_id}{Optional. String. A comma-separated list of channel IDs. Limits response to subscriptions matching those channels.}

\item{order}{method that will be used to sort resources in the API response. Takes one of the following: alphabetical, relevance, unread}

\item{page_token}{Specific page in the result set that should be returned. Optional. String.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
named list of subscriptions
}
\description{
Get Subscriptions
}
\examples{
\dontrun{
get_subscriptions(filter=c(channel_id="UChTJTbr5kf3hYazJZO-euHg"))
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/subscriptions/list}
}

