% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_tteICE.R
\name{predict.tteICE}
\alias{predict.tteICE}
\title{Predict method for 'tteICE' objects at specific time points}
\usage{
\method{predict}{tteICE}(object, timeset = NULL, ...)
}
\arguments{
\item{object}{A fitted object returned by the function \code{tteICE}, \code{surv.tteICE}, or \code{scr.tteICE}.}

\item{timeset}{Time at which to predict the risk.
If \code{timeset=NULL}, risks will be predict at the quartiles of the maximum follow-up time.}

\item{...}{Other arguments in function \code{\link[stats]{predict}}}
}
\value{
A matrix with each row being time points, potential cumulative incidences (under
treated and under control), treatment effects, standard errors, and P-values.

predict a tteICE object.
The meanings of each row are: time points, potential cumulative incidences (under
treated and under control), treatment effects, standard errors, and P-values.
}
\description{
This function predicts the potential cumulative incidence function and treatment effect at
specific time points.
}
\examples{
## load data
data(bmt)
bmt = transform(bmt, d4=d2+d3)
A = as.numeric(bmt$group>1)
bmt$A = A
X = as.matrix(bmt[,c('z1','z3','z5')])

## predict results at specified time points
## model fitting using semicompeting risk data
fit1 = scr.tteICE(A, bmt$t1, bmt$d1, bmt$t2, bmt$d2, "composite")
predict(fit1, timeset=c(670,2000))

## predict results without specifying any time points
## model fitting using competing risk data
fit2 = surv.tteICE(A, bmt$t2, bmt$d4, "composite")
predict(fit2)

## a simpler way
library(survival)
fit3 = tteICE(Surv(t2, d4, type = "mstate")~A|z1+z3+z5,
              data=bmt, strategy="composite", method='eff')
predict(fit3, timeset=c(670,2000))
predict(fit3)


}
\seealso{
\code{\link[tteICE]{scr.tteICE}}, \code{\link[tteICE]{surv.tteICE}}, \code{\link[tteICE]{tteICE}}
\code{\link[tteICE]{surv.boot}}

\code{\link[tteICE]{surv.tteICE}}, \code{\link[tteICE]{scr.tteICE}},
\code{\link[tteICE]{tteICE}}
}
