% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensembling-pipes.R
\name{model_recent_performance}
\alias{model_recent_performance}
\title{Recent performance of models using EMASE}
\usage{
model_recent_performance(Y_hat, Y, lambda, omega, pre_weights)
}
\arguments{
\item{Y_hat}{A \code{data.frame} containing the predictions of
each base model;}

\item{Y}{know true values from past data to compare the predictions to;}

\item{lambda}{Window size. Number of periods to average
over when computing \strong{MASE};}

\item{omega}{Ratio of top models in the committee;}

\item{pre_weights}{The initial weights of the models, computed in
the available data during the learning phase;}
}
\value{
A list containing two objects:
\describe{
\item{model_scores}{The weights of the models in each time point}
\item{top_models}{Models in the committee in each time point}
}
}
\description{
This function computes \strong{EMASE}, Erfc Moving
Average Squared Error, to quantify the recent
performance of the base models.
}
\seealso{
Other weighting base models: \code{\link{EMASE}},
  \code{\link{build_committee}},
  \code{\link{get_top_models}},
  \code{\link{model_weighting}}, \code{\link{select_best}}
}
\concept{weighting base models}
