% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-classes.r
\name{ade_hat}
\alias{ade_hat}
\title{Predictions by an ADE ensemble}
\usage{
ade_hat(y_hat, Y_hat, Y_committee, E_hat)
}
\arguments{
\item{y_hat}{combined predictions of the ensemble
\code{\link{ADE}}. A numeric vector;}

\item{Y_hat}{a matrix containing the predictions made by
individual models;}

\item{Y_committee}{a list describing the models selected for
predictions at each time point (according to \strong{lambda}
and \strong{omega});}

\item{E_hat}{predictions of error of each base model, estimated
by their respective meta model associate;}
}
\description{
Predictions produced by a \code{\link{ADE-class}} object.
It contains \strong{y_hat}, the combined predictions,
\strong{Y_hat}, the predictions of each base model,
\strong{Y_committee}, the base models used for prediction
at each time point, and \strong{E_hat}, the loss predictions
by each meta-model.
}
\seealso{
\code{\link{ADE-class}} for generating an ADE ensemble.

Other ensemble predictions: \code{\link{ade_hat-class}},
  \code{\link{dets_hat-class}}, \code{\link{dets_hat}}
}
\concept{ensemble predictions}
\keyword{internal}
