% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-weights.r
\docType{methods}
\name{update_weights}
\alias{update_weights}
\alias{update_weights,ADE-method}
\alias{update_weights,DETS-method}
\title{Updating the weights of base models}
\usage{
update_weights(object, newdata)

\S4method{update_weights}{ADE}(object, newdata)

\S4method{update_weights}{DETS}(object, newdata)
}
\arguments{
\item{object}{a \code{\link{ADE-class}} or \code{\link{DETS-class}} model object;}

\item{newdata}{new data used to update the most
recent observations of the time series. At prediction time
these observations are used to compute the weights of the base models}
}
\description{
Update the weights of base models of a \code{\link{ADE-class}}
or \code{\link{DETS-class}} ensemble.
This is accomplished by using computing the loss of the base models
in new recent observations.
}
\note{
Updating the weights of an ensemble is only necessary between
different calls of the functions \code{predict} or \code{forecast}.
Otherwise, if consecutive know observations are predicted
(e.g. a validation/test set) the updating is automatically done internally.
}
\examples{
data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)

# toy size for checks
train <- dataset[1:300,]
test <- dataset[301:305, ]

specs <- model_specs(c("bm_ppr","bm_glm","bm_mars"), NULL)
## same with model <- DETS(target ~., train, specs)
model <- ADE(target ~., train, specs)

# if consecutive know observations are predicted (e.g. a validation/test set)
# the updating is automatically done internally.
predictions1 <- predict(model, test)@y_hat

# otherwise, the models need to be updated
predictions <- numeric(nrow(test))
# predict new data and update the weights of the model
for (i in seq_along(predictions)) {
  predictions[i] <- predict(model, test[i, ])@y_hat

  model <- update_weights(model, test[i, ])
}

all.equal(predictions1, predictions)


}
\seealso{
\code{\link{update_weights}} for the weight updating method
for an \code{\link{ADE}} model, and \code{\link{update_weights}} for the same method
for a \code{\link{DETS}} model

Other updating models: \code{\link{update_ade_meta}},
  \code{\link{update_ade}}
}
