% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node.R
\name{node-child-by-field}
\alias{node-child-by-field}
\alias{node_child_by_field_id}
\alias{node_child_by_field_name}
\title{Get a node's child by field id or name}
\usage{
node_child_by_field_id(x, id)

node_child_by_field_name(x, name)
}
\arguments{
\item{x}{\verb{[tree_sitter_node]}

A node.}

\item{id}{\verb{[integer(1)]}

The field id of the child to return.}

\item{name}{\verb{[character(1)]}

The field name of the child to return.}
}
\value{
A child of \code{x}, or \code{NULL} if no matching child can be found.
}
\description{
These functions return children of \code{x} by field id or name.
\itemize{
\item \code{node_child_by_field_id()} retrieves a child by field id.
\item \code{node_child_by_field_name()} retrieves a child by field name.
}

Use \code{\link[=language_field_id_for_name]{language_field_id_for_name()}} to get the field id for a field name.
}
\examples{
\dontshow{if (rlang::is_installed("treesitter.r")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
language <- treesitter.r::language()
parser <- parser(language)

text <- "fn <- function() { 1 + 1 }"
tree <- parser_parse(parser, text)
node <- tree_root_node(tree)

# Navigate to first child
node <- node_child(node, 1)
node

# Get the field name of the first child
name <- node_field_name_for_child(node, 1)
name

# Now get the child again by that field name
node_child_by_field_name(node, name)

# If you need to look up by field name many times, you can look up the
# more direct field id first and use that instead
id <- language_field_id_for_name(language, name)
id

node_child_by_field_id(node, id)

# Returns `NULL` if no matching child
node_child_by_field_id(node, 10000)
\dontshow{\}) # examplesIf}
}
