% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.traits.R
\name{link.traits}
\alias{link.traits}
\title{link.traits}
\usage{
link.traits(base.trait, next.trait, link.type, link.args, trait.name)
}
\arguments{
\item{base.trait}{One or more \code{"treats"} \code{"traits"} object(s) to be considered first.}

\item{next.trait}{One or more \code{"treats"} \code{"traits"} object(s) to be considered sequentially.}

\item{link.type}{The type of link between the traits. Can be \code{"conditional"}.}

\item{link.args}{Optional arguments to interpret the link between the objects (based on the \code{link.type}).}

\item{trait.name}{Optional, a \code{character}, the name the resulting trait.}
}
\value{
This function outputs a \code{treats} object that is a named list of elements handled internally by the \code{\link{treats}} function.
}
\description{
Linking traits objects together to simulate simulate them sequentially.
}
\details{
This function allows to link several traits together in the simulations. The current link types implemented are:
\itemize{
     \item{"conditional"}: this allows to link the \code{next.trait} traits conditionally to the \code{base.trait} one. For example if \code{base.trait} is a \code{\link{discrete.process}} with two states \code{0} and \code{1} and \code{next.trait} is a list of two traits with two different processes \code{\link{OU.process}} and \code{\link{BM.process}}. The simulations generates a first trait using \code{base.trait} and then a second one using one of the two processes in \code{next.trait} depending on the results of \code{base.trait}. The link arguments \code{link.args} must be a list of logical functions to interpret \code{x1}, the results of the \code{base.trait}. For example, \code{list(function(x1){x1 == 0}, function(x1){x1 == 1})} will generate a trait using the first \code{next.trait} if \code{x1} is equal to \code{0} or using the second \code{next.trait} if \code{x1} is equal to \code{1}.
}
}
\examples{
## Setting up a discrete trait
discrete_trait <- make.traits(discrete.process,
       process.args = list(transitions = matrix(c(3, 0.2, 0.05, 3), 2, 2)),
       trait.names  = "discrete")

## Setting up one dummy trait (always outputs 1)
always_one <- make.traits(process = function(x0 = 0, edge.length = 1) {return(1)},
                          trait.names = "one")
## Setting up a Brownian motion trait
BM_trait <- make.traits(trait.names = "BM")

## Setting a condition list to link all traits
## (if discrete trait is 0, simulate a BM trait)
## (if discrete trait is 1, simulate the always one trait)
conditions <- list("choose.BM"  = function(x1) {x1 == 0},
                   "choose.one" = function(x1) {x1 == 1}) 

## Creating the linked trait
conditional <- link.traits(base.trait = discrete_trait,
                           next.trait = list(BM_trait, always_one),
                           link.type  = "conditional",
                           link.args  = conditions)

## Simulating a tree using this trait
treats(stop.rule = list(max.living = 200),
       traits    = conditional)

}
\seealso{
\code{\link{treats}} \code{\link{trait.process}} \code{\link{make.traits}}
}
\author{
Thomas Guillerme
}
