% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interest-rate.R
\name{tr_real_long_term}
\alias{tr_real_long_term}
\title{Daily treasury real long-term rate averages}
\source{
\url{https://home.treasury.gov/treasury-daily-interest-rate-xml-feed}
}
\usage{
tr_real_long_term(date = NULL)
}
\arguments{
\item{date}{(\code{character(1)} | \code{numeric(1)}) date in format yyyy or yyyymm.
If \code{NULL}, all data is returned. Default \code{NULL}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} containing the rates or \code{NULL} when no entries were found.
}
\description{
The Long-Term Real Rate Average is the unweighted average of bid real yields
on all outstanding TIPS with remaining maturities of more than 10 years and
is intended as a proxy for long-term real rates.
}
\examples{
\dontrun{
# get data for a single month
tr_real_long_term("202201")
# or for the entire year
tr_real_long_term(2022)
}
}
\seealso{
Other interest rate: 
\code{\link{tr_bill_rates}()},
\code{\link{tr_long_term_rate}()},
\code{\link{tr_real_yield_curve}()},
\code{\link{tr_yield_curve}()}
}
\concept{interest rate}
