% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqic_10.R
\name{seqic_indicator_10}
\alias{seqic_indicator_10}
\title{SEQIC Indicator 10 – Trauma Team Activation Appropriateness}
\usage{
seqic_indicator_10(
  data,
  level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id,
  transfer_out_indicator,
  trauma_team_activation_level,
  iss,
  nfti,
  groups = NULL,
  calculate_ci = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing trauma incident records.}

\item{level}{Column indicating the trauma center designation level (e.g., I,
II, III, IV).}

\item{included_levels}{Character vector indicating what facility levels to
include in the analysis.  Defaults to \code{c("I", "II", "III", "IV")}.}

\item{unique_incident_id}{Unique identifier for each record.}

\item{transfer_out_indicator}{Column name indicating whether the patient was
transferred out of the initial trauma center to definitive care. Logical,
character, or factor type. Values representing "No" (e.g., FALSE, "No")
indicate no transfer out.}

\item{trauma_team_activation_level}{Column indicating the trauma team
activation level (e.g., \code{"Level 1"}, \code{"Level 2"}, \code{"Level 3"},
\code{"Consultation"}). Must be character or factor.}

\item{iss}{Optional numeric column representing the Injury Severity Score.}

\item{nfti}{Optional column indicating Need For Trauma Intervention
classification of positive or negative. Should be character, factor, or
logical.}

\item{groups}{Optional character vector of column names used for grouping
results.}

\item{calculate_ci}{Optional; if not \code{NULL}, must be \code{"wilson"} or
\code{"clopper-pearson"} to compute confidence intervals.}

\item{...}{
  Arguments passed on to \code{\link[nemsqar:nemsqa_binomial_confint]{nemsqar::nemsqa_binomial_confint}}
  \describe{
    \item{\code{conf.level}}{Numeric value between 0 and 1 indicating the confidence
level. Defaults to 0.95 (95\% confidence interval).}
    \item{\code{correct}}{Logical, indicating whether to apply continuity correction for
Wilson intervals. Defaults to \code{TRUE}.}
  }}
}
\value{
A list of two tibbles with counts and proportions for SEQIC
Indicators 10a, 10b, and 10c, along with model diagnostics for the Cribari
or NFTI ouputs.  The proportions in 10a, 10b, and 10c will optionally
include 95\% confidence intervals.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculates three trauma system quality indicators related to trauma team
activations where the patient was kept at the facility:
\itemize{
\item 10a: Proportion of patients meeting triage criteria (based on Injury
Severity Score or Need For Trauma Intervention) who received low-level
or no activation (undertriage).
\item 10b: Proportion of patients not meeting triage criteria who received
highest-level trauma activation (overtriage).
\item 10c: Proportion of major trauma patients receiving a full activation
(undertriage via Peng & Xiang, 2019).

(10a, 10b, 10c can be based on Injury Severity Score or Need For Trauma
Intervention based on user choice)
}

Users may stratify results by one or more grouping variables and optionally
compute confidence intervals.
}
\details{
This function:
\itemize{
\item Restricts analysis to Level I–IV trauma centers.
\item Removes duplicate incidents using \code{unique_incident_id}.
\item Classifies each record as meeting or not meeting triage criteria
based on ISS or NFTI logic.
\item Optionally computes 95\% confidence intervals for each indicator.
}

Users must ensure appropriate column names are passed and data is
pre-processed to include the necessary fields without missing critical
identifiers or timestamps.
}
\examples{
# Packages
library(dplyr)
library(traumar)

# Simulated data for SEQIC Indicator 10
test_data <- tibble::tibble(
  id = as.character(1:12),
  trauma_level = c("I", "II", "III", "IV", "II", "I", "IV", "III", "II", "I",
  "III", "IV"),
  activation = c("Level 1", "Level 2", "None", "Consultation", "Level 1",
  "Level 1", "None", "Level 3", "Level 1", "Consultation", "None", "Level
  2"),
  acute_transfer = rep("No", 12),
  iss = c(25, 10, 16, 8, 30, 45, 12, 9, 28, 6, 17, 14),
  nfti = c(TRUE, FALSE, TRUE, FALSE, TRUE, TRUE, FALSE, FALSE, TRUE, FALSE,
  TRUE, TRUE),
  region = rep(c("East", "West"), each = 6)
)

# Run the function, this will succeed
traumar::seqic_indicator_10(
  data = test_data,
  level = trauma_level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id = id,
  transfer_out_indicator = acute_transfer,
  trauma_team_activation_level = activation,
  iss = iss,
  nfti = NULL,
  groups = "region",
  calculate_ci = "wilson"
)

# Run the function, this will fail
try(
  traumar::seqic_indicator_10(
  data = test_data,
  level = trauma_level,
  included_levels = c("I", "II", "III", "IV"),
  unique_incident_id = id,
  transfer_out_indicator = acute_transfer,
  trauma_team_activation_level = activation,
  iss = iss,
  nfti = nfti,
  groups = "region",
  calculate_ci = "wilson"
))

}
\references{
Beam G, Gorman K, Nannapaneni S, Zipf J, Simunich T, et al. (2022) Need for
Trauma Intervention and Improving Under-Triaging in Geriatric Trauma
Patients: undertriaged or Misclassified. Int J Crit Care Emerg Med 8:136.
doi.org/10.23937/2474-3674/1510136

Peng J, Xiang H. Trauma undertriage and overtriage rates: are we using the
wrong formulas? Am J Emerg Med. 2016 Nov;34(11):2191-2192. doi:
10.1016/j.ajem.2016.08.061. Epub 2016 Aug 31. PMID: 27615156; PMCID:
PMC6469681.

Roden-Foreman JW, Rapier NR, Yelverton L, Foreman ML. Asking a Better
Question: Development and Evaluation of the Need For Trauma Intervention
(NFTI) Metric as a Novel Indicator of Major Trauma. J Trauma Nurs. 2017
May/Jun;24(3):150-157. doi: 10.1097/JTN.0000000000000283. PMID: 28486318.
}
\author{
Nicolas Foss, Ed.D., MS
}
