% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{schwartz_US}
\alias{schwartz_US}
\title{eGFR by bedside Schwartz formula (US units)}
\usage{
schwartz_US(creat, height)
}
\arguments{
\item{creat}{numeric vector of creatinine levels in µmol/l (or mg/dl if units = "US")}

\item{height}{numeric vector of heights in cm}
}
\value{
numeric vector of eGFR values
}
\description{
A wrapper function for the schwartz() vectorised formula to calculate estimate glomerular filtration rate in children
using the bedside Schwartz formula, using
serum creatinine in mg/dl. Use the schwartz() function instead for µmol/l.
}
\details{
Reference: Schwartz GJ, Munoz A, Schneider MF et al. New equations to estimate GFR in children
with CKD. J Am Soc Nephrol 2009; 20(3):629-637.
}
\examples{
# calculate using creatinine in -mg/dl
schwartz_US(creat = 0.7, height = 101)
}
