% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uskdri.R
\name{kdpi_US}
\alias{kdpi_US}
\title{US KDPI (US units)}
\usage{
kdpi_US(age, height, weight, eth, htn, dm, cva, creat, hcv, dcd,
  scaling = 1)
}
\arguments{
\item{age}{numeric vector of donor ages in years}

\item{height}{numeric vector of donor heights in cm}

\item{weight}{numeric vector of donor weights in kg}

\item{eth}{character string vector of donor ethnicity, "black" or "non-black"}

\item{htn}{numeric vector of donor hypertension history (1 = yes, 0 = no)}

\item{dm}{numeric vector of donor diabetes history (1 = yes, 0 = no)}

\item{cva}{numeric vector of whether donor death due to CVA (1 = yes, 0 = no)}

\item{creat}{numeric vector of donor serum creatinine (µmol/l)}

\item{hcv}{numeric vector of donor hepatitis C history (1 = yes, 0 = no)}

\item{dcd}{numeric vector of type of donor (1 = DCD, 0 = DBD)}

\item{scaling}{single numeric value for OPTN scaling factor (optional, defaults to 1)}
}
\value{
numeric vector of US KDRI values
}
\description{
Wrapper function for the kdpi() vectorised function to calculate US KDPI percentile as published by OPTN/UNOS,
using creatinine measured in mg/dl (please use the kdpi() function for µmol/l).
}
\details{
The KDRI is calculated from KDRI normalised by a scaling factor based on the median KDRI in the previous year.
For 2018, this was approximately 1.250609 as is published on the OPTN website.
The scaling parameter in this function defaults to 1, so can be left out to calculate the KDPI without scaling.

This function requires the dplyr package to be installed.

Reference: Rao PS, Schaubel DE, Guidinger MK, et al. A Comprehensive Risk Quantification Score
for Deceased Donor Kidneys: The Kidney Donor Risk Index. Transplantation 2009; 88:231-236.
}
\examples{
# with creatinine in mg/dl
kdpi_US(age = 40, height = 170, weight = 80, eth = "non-black", htn = 0, dm = 0,
    cva = 0, creat = 1.4, hcv = 0, dcd = 0, scaling = 1.250609)
}
