% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/punctuate.R
\name{punctuate}
\alias{punctuate}
\title{Punctuation Removal for Text}
\usage{
punctuate(
  text,
  allowPunctuations = c("-", "?", "'", "\\"", ";", ",", ".", "!")
)
}
\arguments{
\item{text}{Character vector or list.
Text in a vector or list data format}

\item{allowPunctuations}{Character vector.
Punctuations that should be allowed in the text.
Defaults to common punctuations in English text}
}
\value{
Returns text with only the allowed punctuations
}
\description{
Keeps the punctuations you want and removes the punctuations you don't
}
\details{
Coarsely removes punctuations from text. Keeps general punctuations
that are used in most English language text. Apostrophes are much trickier.
For example, not allowing "'" will remove apostrophes from contractions
like "can't" becoming "cant"
}
\examples{
# Load data
data(neo_ipip_extraversion)

# Example text 
text <- neo_ipip_extraversion$friendliness

# Keep only periods
punctuate(text, allowPunctuations = c("."))

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
