% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{calculate_procrustes_difference}
\alias{calculate_procrustes_difference}
\title{Calculate Procrustes Difference Between Maps}
\usage{
calculate_procrustes_difference(map1, map2)
}
\arguments{
\item{map1}{Data frame with coordinates from first map (must have X, X.1 columns)}

\item{map2}{Data frame with coordinates from second map (must have X, X.1 columns)}
}
\value{
A single numeric value representing the sum of squared differences after Procrustes transformation.
}
\description{
Computes the quantitative difference between two maps using Procrustes analysis.
The difference is calculated as the sum of squared differences after optimal
rotation and scaling.
}
\examples{
# Create sample map data
map1 <- data.frame(name = letters[1:10], X = rnorm(10), X.1 = rnorm(10))
map2 <- data.frame(name = letters[1:10], X = rnorm(10), X.1 = rnorm(10))
diff <- calculate_procrustes_difference(map1, map2)
}
