% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_communities}
\alias{plot.tna_communities}
\title{Plot Communities}
\usage{
\method{plot}{tna_communities}(x, colors, method = "spinglass", ...)
}
\arguments{
\item{x}{A \code{communities} object generated by the \code{find_communities} method.
Each community detection method maps nodes or points in to a specific
communities.}

\item{colors}{A \code{character} vector of color values used for visualizing
community assignments.}

\item{method}{A \code{character} string naming a community detection method to
use for coloring the plot. See \code{\link[=communities]{communities()}} for details.}

\item{...}{Additional arguments passed to \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}
}
\value{
A \code{qgraph} object in which the nodes are colored by community.
}
\description{
This function visualizes the communities detected within a \code{tna} object
based on different community detection algorithms and their corresponding
color mappings.
}
\examples{
model <- tna(group_regulation)
comm <- communities(model)
plot(comm, method = "leading_eigen")

}
\seealso{
Community detection functions
\code{\link{communities}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.tna_communities}()}
}
\concept{communities}
