% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_wq_demo.R, R/wq_buranhem.R
\docType{data}
\name{wq_demo}
\alias{wq_demo}
\title{Example water quality dataset (subset of real data)}
\format{
A tibble/data.frame with 20 rows and 14 columns:
\describe{
\item{rio}{character, river name}
\item{ponto}{character, monitoring point id}
\item{data}{Date, sampling date}
\item{ph}{numeric, pH}
\item{od}{numeric, dissolved oxygen (mg/L)}
\item{turbidez}{numeric, NTU}
\item{dbo}{numeric, mg/L}
\item{coliformes}{numeric, MPN/100 mL}
\item{p_total}{numeric, total phosphorus (mg/L)}
\item{nt_total}{numeric, total nitrogen (mg/L)}
\item{temperatura}{numeric, degrees Celsius}
\item{tds}{numeric, total dissolved solids (mg/L)}
\item{lat}{numeric, latitude}
\item{lon}{numeric, longitude}
}

A tibble/data.frame. See \code{wq_demo} documentation for column details.
}
\source{
Subset of dataset-real.csv (BURANHEM river, 4 sites, years 2020–2024).
}
\usage{
data(wq_demo)

data(wq_demo)
}
\description{
A small subset of real monitoring data used in examples and vignettes. Now includes extra columns \code{rio}, \code{lat}, \code{lon}.

This dataset contains real water quality measurements collected by INEMA (Instituto do Meio Ambiente e Recursos Hidricos, Bahia) during monitoring campaigns conducted between 2021 and 2024 in the Rio Buranhem watershed, municipality of Porto Seguro, Bahia, Brazil. The dataset was incorporated into the package for demonstration, reproducibility and methodological illustration, following the analytical workflow implemented in tikatuwq. Parameters include sampling dates, site identifiers and multiple physicochemical variables measured during field campaigns.
}
\details{
The dataset is a real subset selected from BURANHEM river (dataset-real.csv), used for reproducible examples and vignettes.
Covers 4 monitoring points and years 2020–2024. All core columns for IQA/CONAMA/plotting helpers are present.
}
\examples{
data("wq_demo", package = "tikatuwq")
head(wq_demo)
# quick IQA example:
# iqa(wq_demo, na_rm = TRUE)

}
\seealso{
\code{\link[=iqa]{iqa()}}, \code{\link[=conama_check]{conama_check()}}, \code{\link[=plot_series]{plot_series()}},
\code{\link[=plot_box]{plot_box()}}, \code{\link[=plot_iqa]{plot_iqa()}}, \code{\link[=plot_heatmap]{plot_heatmap()}}

wq_demo
}
\keyword{datasets}
