% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conama.R
\name{conama_check}
\alias{conama_check}
\title{CONAMA conformity check (detailed; default class = "2")}
\usage{
conama_check(df, classe = "2")
}
\arguments{
\item{df}{A tibble/data.frame with parameter columns (e.g., ph, turbidez, od, dbo).}

\item{classe}{Character class label (e.g., "especial", "1", "2", "3", "4").}
}
\value{
The input \code{df} with additional columns per parameter as described.
}
\description{
For each parameter present in \code{df}, adds columns:
\itemize{
\item \code{*_ok} (logical),
\item \code{*_status} one of \code{"ok"}, \code{"acima_do_maximo"}, \code{"abaixo_do_minimo"},
\item \code{*__lim_min} and \code{*__lim_max} (thresholds used),
\item \code{*__delta} (difference to the relevant limit; >0 above max, <0 below min, 0 if ok).
}
If multiple limit rows exist for the same parameter, \code{*_ok} is TRUE if
any row is satisfied; for \code{status/lim_min/lim_max/delta}, the first
satisfied row is chosen; if none satisfy, the row with the smallest
absolute violation (min |delta|) is used.
}
\examples{
\dontrun{
data("wq_demo", package = "tikatuwq")
head(conama_check(wq_demo, classe = "2"))
}

}
\seealso{
\code{\link[=conama_limits]{conama_limits()}}, \code{\link[=conama_summary]{conama_summary()}}, \code{\link[=conama_report]{conama_report()}}, \code{\link[=conama_text]{conama_text()}}
}
