% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{getMutCount}
\alias{getMutCount}
\title{Determine the mutation counts from allele calls}
\usage{
getMutCount(samples, allele_calls, germline_db)
}
\arguments{
\item{samples}{a vector of IMGT-gapped sample V sequences}

\item{allele_calls}{a vector of strings respresenting Ig allele calls for
the sequences in \code{samples}, where multiple
calls are separated by a comma}

\item{germline_db}{a vector of named nucleotide germline sequences
matching the calls detailed in \code{allele_calls}}
}
\value{
A list equal in length to \code{samples}, containing the Hamming
          distance to each germline allele contained within each call within
          each element of \code{samples}
}
\description{
\code{getMutCount} takes a set of nucleotide sequences and their allele calls
and determines the distance between that seqeunce and any germline alleles
contained within the call
}
\examples{
\donttest{
# Use createGermlines to insert a mutation into a germline sequence
sample_seqs <- c(GermlineIGHV[2],
                 createGermlines(GermlineIGHV[1], 103, "G"),
                 createGermlines(GermlineIGHV[1], 107, "C"))

# Pretend that one sample sequence has received an ambiguous allele call
sample_alleles <- c(paste(names(GermlineIGHV[1:2]), collapse=","),
                    names(GermlineIGHV[2]),
                    names(GermlineIGHV[1]))

# Compare each sequence to its assigned germline(s) to determine the distance
getMutCount(sample_seqs, sample_alleles, GermlineIGHV)
}

}
