% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary-functions}
\alias{summary-functions}
\alias{mean}
\alias{sum}
\alias{prod}
\alias{sd}
\alias{var}
\alias{median}
\alias{quantile}
\title{NA-aware Summary Functions}
\usage{
mean(x, na.rm = TRUE, ...)

sum(x, na.rm = TRUE, ...)

prod(x, na.rm = TRUE, ...)

sd(x, na.rm = TRUE, ...)

var(x, na.rm = TRUE, ...)

median(x, na.rm = TRUE, ...)

quantile(x, na.rm = TRUE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{...}{Additional arguments passed to the base function.}
}
\value{
The computed summary statistic.
}
\description{
Drop-in replacements for summary functions that default to \code{na.rm = TRUE}
and warn when missing values are removed.
}
\examples{
x <- c(1, 2, NA, 4)
mean(x)

# Suppress warnings
options(tidyna.warn = FALSE)
mean(x)
options(tidyna.warn = TRUE)

# Use base behavior
mean(x, na.rm = FALSE)

}
