% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_azure_openai.R
\name{fetch_azure_openai_batch}
\alias{fetch_azure_openai_batch}
\title{Fetch Results for an Azure OpenAI Batch}
\usage{
fetch_azure_openai_batch(
  .llms,
  .endpoint_url = Sys.getenv("AZURE_ENDPOINT_URL"),
  .batch_id = NULL,
  .dry_run = FALSE,
  .max_tries = 3,
  .timeout = 60
)
}
\arguments{
\item{.llms}{A list of \code{LLMMessage} objects that were part of the batch.}

\item{.endpoint_url}{Base URL for the API (default:  Sys.getenv("AZURE_ENDPOINT_URL")).}

\item{.batch_id}{Character; the unique identifier for the batch. By default this is NULL
and the function will attempt to use the \code{batch_id} attribute from \code{.llms}.}

\item{.dry_run}{Logical; if \code{TRUE}, returns the constructed request without executing it (default: \code{FALSE}).}

\item{.max_tries}{Integer; maximum number of retries if the request fails (default: \code{3}).}

\item{.timeout}{Integer; request timeout in seconds (default: \code{60}).}
}
\value{
A list of updated \code{LLMMessage} objects, each with the assistant's response added if successful.
}
\description{
This function retrieves the results of a completed Azure OpenAI batch and updates
the provided list of \code{LLMMessage} objects with the responses. It aligns each
response with the original request using the \code{custom_id}s generated in \code{send_azure_openai_batch()}.
}
