% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windbarbs.R
\name{windbarbs}
\alias{windbarbs}
\title{Wind barbs}
\usage{
windbarbs(cx, cy, direction, speed = NA, cex = 1)
}
\arguments{
\item{cx}{x coordinates on a plot}

\item{cy}{y coordinates on a plot}

\item{direction}{wind direction (0-360 degrees)}

\item{speed}{wind speed in knots}

\item{cex}{symbol size. Default 1}
}
\value{
wind barb graphics
}
\description{
A function to plot a wind barb. This is a modified version of `station.symbol` function from the RadioSonde package. 
Currently wind barbs are supported up to 190 knots.
}
\examples{
plot(1, xaxt = 'n', yaxt = 'n', xlab = "", ylab = "", frame = FALSE)
windbarbs(cx = 1, cy = 1, direction = 120, speed = 99, cex = 5)

# multiplot
oldpar = par(no.readonly = TRUE)

par(mfrow=c(5,4), mar = c(1,1,1,1))
for (i in 19:38){
  sc = 5
  plot(0:2, xaxt = 'n', yaxt = 'n', type = "n", xlab = "", ylab = "")
  text(1.4,1, i*sc, cex = 1.5)
  windbarbs(cx = 2, cy = 1, direction = 60, speed = i*sc, cex = 3)
}

par(oldpar) # restore drawing settings
}
