% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{matrix2graph}
\alias{matrix2graph}
\title{Convert a matrix or column-sparse matrix to a list of edges and nodes for
use by \code{\link{graphjs}}.}
\usage{
matrix2graph(M)
}
\arguments{
\item{M}{either a matrix or any of the possible column sparse matrix objects from the \link{Matrix} package.}
}
\value{
A list with node and edges data frame entries used by \code{\link{graphjs}}.
}
\description{
Convert a matrix or column-sparse matrix to a list of edges and nodes for
use by \code{\link{graphjs}}.
}
\note{
Numeric graphs are assumed to be weighted and the edge "size" values are set to the corresponding matrix entries.
}
\examples{
data(LeMis)
M <- graph2Matrix(LeMis$edges, LeMis$nodes)
G <- matrix2graph(M)
}
\seealso{
\code{\link{graphjs}}, \code{\link{graph2Matrix}}
}

