% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,brmsfit-method}
\alias{extract,brmsfit-method}
\alias{extract.brmsfit}
\title{\code{\link{extract}} method for \code{brmsfit} objects}
\usage{
\S4method{extract}{brmsfit}(
  model,
  use.HDI = TRUE,
  level = 0.9,
  include.random = TRUE,
  include.rsquared = TRUE,
  include.nobs = TRUE,
  include.loo.ic = TRUE,
  reloo = FALSE,
  include.waic = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{use.HDI}{Report highest posterior density (HPD) intervals (HDI) using
the \code{\link[coda]{HPDinterval}} function in the \pkg{coda} package,
with the probability given in the \code{level} argument, instead of the
default 95 percent posterior quantiles?}

\item{level}{Significance level (\code{1 - alpha}) for HPDs (in combination
with the \code{use.HDI} argument).}

\item{include.random}{Include random effects (standard deviations) in the GOF
block of the table?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.loo.ic}{Report Leave-One-Out Information Criterion?}

\item{reloo}{Recompute exact cross-validation for problematic observations
for which approximate leave-one-out cross-validation may return incorrect
results? This is done using the \code{\link[brms]{reloo.brmsfit}} function
and may take some time to compute.}

\item{include.waic}{Report Widely Applicable Information Criterion (WAIC)?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{brmsfit} objects created by the
\code{\link[brms]{brm}} function in the \pkg{brms} package.
}
\author{
Hyunjin (Jin) Song, Philip Leifeld
}
