% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-chk.R
\name{text-expectations}
\alias{text-expectations}
\alias{expect_text_miss}
\alias{expect_text_nmiss}
\title{Expectations: text}
\usage{
expect_text_miss(
  vars,
  miss = getOption("testdat.miss_text"),
  flt = TRUE,
  data = get_testdata()
)

expect_text_nmiss(
  vars,
  miss = getOption("testdat.miss_text"),
  flt = TRUE,
  data = get_testdata()
)
}
\arguments{
\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{miss}{A vector of values to be treated as missing. The
\link[=testdat]{testdat.miss} or \link[=testdat]{testdat.miss_text} option is used by
default.}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
Test whether variables in a data frame contain common NULL placeholders.
}
\examples{

sales <- data.frame(
  sale_id = 1:5,
  date = c("20200101", "null", "20200102", "20200103", "null"),
  sale_price = c(10, -1, 30, 40, -1)
)

# Dates not missing
try(expect_text_nmiss(date, data = sales))

# Date missing if price negative
try(expect_text_miss(date, flt = sale_price \%in\% -1, data = sales))

}
\seealso{
\link[=chk-text]{Checks: text}

Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{datacomp-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{expect_depends}()},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
