% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{util_handling_additional_fun_params}
\alias{util_handling_additional_fun_params}
\alias{retrieve_extra_afun_params}
\alias{get_additional_afun_params}
\title{Utilities to handle extra arguments in analysis functions}
\usage{
retrieve_extra_afun_params(extra_afun_params)

get_additional_afun_params(add_alt_df = FALSE)
}
\arguments{
\item{extra_afun_params}{(\code{list})\cr list of additional parameters (\code{character}) to be
retrieved from the environment. Curated list is present in \link[rtables:additional_fun_params]{rtables::additional_fun_params}.}

\item{add_alt_df}{(\code{logical})\cr if \code{TRUE}, the function will also add \code{.alt_df} and \code{.alt_df_row}
parameters.}
}
\value{
\itemize{
\item \code{retrieve_extra_afun_params} returns a list of the values of the parameters in the environment.
}

\itemize{
\item \code{get_additional_afun_params} returns a list of additional parameters.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Important additional parameters, useful to modify behavior of analysis and summary
functions are listed in \link[rtables:additional_fun_params]{rtables::additional_fun_params}. With these utility functions
we can retrieve a curated list of these parameters from the environment, and pass them
to the analysis functions with dedicated \code{...}; notice that the final \verb{s_*} function
will get them through argument matching.
}
\section{Functions}{
\itemize{
\item \code{retrieve_extra_afun_params()}: Retrieve additional parameters from the environment.

\item \code{get_additional_afun_params()}: Curated list of additional parameters for
analysis functions. Please check \link[rtables:additional_fun_params]{rtables::additional_fun_params} for precise descriptions.

}}
\keyword{internal}
