% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_km.R
\name{g_km}
\alias{g_km}
\alias{kaplan_meier}
\title{Kaplan-Meier plot}
\usage{
g_km(
  df,
  variables,
  control_surv = control_surv_timepoint(),
  col = NULL,
  lty = NULL,
  lwd = 0.5,
  censor_show = TRUE,
  pch = 3,
  size = 2,
  max_time = NULL,
  xticks = NULL,
  xlab = "Days",
  yval = c("Survival", "Failure"),
  ylab = paste(yval, "Probability"),
  ylim = NULL,
  title = NULL,
  footnotes = NULL,
  font_size = 10,
  ci_ribbon = FALSE,
  annot_at_risk = TRUE,
  annot_at_risk_title = TRUE,
  annot_surv_med = TRUE,
  annot_coxph = FALSE,
  annot_stats = NULL,
  annot_stats_vlines = FALSE,
  control_coxph_pw = control_coxph(),
  ref_group_coxph = NULL,
  control_annot_surv_med = control_surv_med_annot(),
  control_annot_coxph = control_coxph_annot(),
  legend_pos = NULL,
  rel_height_plot = 0.75,
  ggtheme = NULL,
  as_list = FALSE,
  draw = lifecycle::deprecated(),
  newpage = lifecycle::deprecated(),
  gp = lifecycle::deprecated(),
  vp = lifecycle::deprecated(),
  name = lifecycle::deprecated(),
  annot_coxph_ref_lbls = lifecycle::deprecated(),
  position_coxph = lifecycle::deprecated(),
  position_surv_med = lifecycle::deprecated(),
  width_annots = lifecycle::deprecated()
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{variables}{(named \code{list})\cr variable names. Details are:
\itemize{
\item \code{tte} (\code{numeric})\cr variable indicating time-to-event duration values.
\item \code{is_event} (\code{logical})\cr event variable. \code{TRUE} if event, \code{FALSE} if time to event is censored.
\item \code{arm} (\code{factor})\cr the treatment group variable.
\item \code{strata} (\code{character} or \code{NULL})\cr variable names indicating stratification factors.
}}

\item{control_surv}{(\code{list})\cr parameters for comparison details, specified by using
the helper function \code{\link[=control_surv_timepoint]{control_surv_timepoint()}}. Some possible parameter options are:
\itemize{
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for survival rate.
\item \code{conf_type} (\code{string})\cr \code{"plain"} (default), \code{"log"}, \code{"log-log"} for confidence interval type,
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note that the option "none" is no longer supported.
}}

\item{col}{(\code{character})\cr lines colors. Length of a vector should be equal
to number of strata from \code{\link[survival:survfit]{survival::survfit()}}.}

\item{lty}{(\code{numeric})\cr line type. If a vector is given, its length should be equal to the number of strata from
\code{\link[survival:survfit]{survival::survfit()}}.}

\item{lwd}{(\code{numeric})\cr line width. If a vector is given, its length should be equal to the number of strata from
\code{\link[survival:survfit]{survival::survfit()}}.}

\item{censor_show}{(\code{flag})\cr whether to show censored observations.}

\item{pch}{(\code{string})\cr name of symbol or character to use as point symbol to indicate censored cases.}

\item{size}{(\code{numeric(1)})\cr size of censored point symbols.}

\item{max_time}{(\code{numeric(1)})\cr maximum value to show on x-axis. Only data values less than or up to
this threshold value will be plotted (defaults to \code{NULL}).}

\item{xticks}{(\code{numeric} or \code{NULL})\cr numeric vector of tick positions or a single number with spacing
between ticks on the x-axis. If \code{NULL} (default), \code{\link[labeling:extended]{labeling::extended()}} is used to determine
optimal tick positions on the x-axis.}

\item{xlab}{(\code{string})\cr x-axis label.}

\item{yval}{(\code{string})\cr type of plot, to be plotted on the y-axis. Options are \code{Survival} (default) and \code{Failure}
probability.}

\item{ylab}{(\code{string})\cr y-axis label.}

\item{ylim}{(\code{numeric(2)})\cr vector containing lower and upper limits for the y-axis, respectively.
If \code{NULL} (default), the default scale range is used.}

\item{title}{(\code{string})\cr plot title.}

\item{footnotes}{(\code{string})\cr plot footnotes.}

\item{font_size}{(\code{numeric(1)})\cr font size to use for all text.}

\item{ci_ribbon}{(\code{flag})\cr whether the confidence interval should be drawn around the Kaplan-Meier curve.}

\item{annot_at_risk}{(\code{flag})\cr compute and add the annotation table reporting the number of patient at risk
matching the main grid of the Kaplan-Meier curve.}

\item{annot_at_risk_title}{(\code{flag})\cr whether the "Patients at Risk" title should be added above the \code{annot_at_risk}
table. Has no effect if \code{annot_at_risk} is \code{FALSE}. Defaults to \code{TRUE}.}

\item{annot_surv_med}{(\code{flag})\cr compute and add the annotation table on the Kaplan-Meier curve estimating the
median survival time per group.}

\item{annot_coxph}{(\code{flag})\cr whether to add the annotation table from a \code{\link[survival:coxph]{survival::coxph()}} model.}

\item{annot_stats}{(\code{string} or \code{NULL})\cr statistics annotations to add to the plot. Options are
\code{median} (median survival follow-up time) and \code{min} (minimum survival follow-up time).}

\item{annot_stats_vlines}{(\code{flag})\cr add vertical lines corresponding to each of the statistics
specified by \code{annot_stats}. If \code{annot_stats} is \code{NULL} no lines will be added.}

\item{control_coxph_pw}{(\code{list})\cr parameters for comparison details, specified using the helper function
\code{\link[=control_coxph]{control_coxph()}}. Some possible parameter options are:
\itemize{
\item \code{pval_method} (\code{string})\cr p-value method for testing hazard ratio = 1.
Default method is \code{"log-rank"}, can also be set to \code{"wald"} or \code{"likelihood"}.
\item \code{ties} (\code{string})\cr method for tie handling. Default is \code{"efron"},
can also be set to \code{"breslow"} or \code{"exact"}. See more in \code{\link[survival:coxph]{survival::coxph()}}
\item \code{conf_level} (\code{proportion})\cr confidence level of the interval for HR.
}}

\item{ref_group_coxph}{(\code{string} or \code{NULL})\cr level of arm variable to use as reference group in calculations for
\code{annot_coxph} table. If \code{NULL} (default), uses the first level of the arm variable.}

\item{control_annot_surv_med}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_surv_med = TRUE}, specified using the \code{\link[=control_surv_med_annot]{control_surv_med_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, and \code{fill}. See \code{\link[=control_surv_med_annot]{control_surv_med_annot()}} for details.}

\item{control_annot_coxph}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_coxph = TRUE}, specified using the \code{\link[=control_coxph_annot]{control_coxph_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, \code{fill}, and \code{ref_lbls}. See \code{\link[=control_coxph_annot]{control_coxph_annot()}} for details.}

\item{legend_pos}{(\code{numeric(2)} or \code{NULL})\cr vector containing x- and y-coordinates, respectively, for the legend
position relative to the KM plot area. If \code{NULL} (default), the legend is positioned in the bottom right corner of
the plot, or the middle right of the plot if needed to prevent overlapping.}

\item{rel_height_plot}{(\code{proportion})\cr proportion of total figure height to allocate to the Kaplan-Meier plot.
Relative height of patients at risk table is then \code{1 - rel_height_plot}. If \code{annot_at_risk = FALSE} or
\code{as_list = TRUE}, this parameter is ignored.}

\item{ggtheme}{(\code{theme})\cr a graphical theme as provided by \code{ggplot2} to format the Kaplan-Meier plot.}

\item{as_list}{(\code{flag})\cr whether the two \code{ggplot} objects should be returned as a list when \code{annot_at_risk = TRUE}.
If \code{TRUE}, a named list with two elements, \code{plot} and \code{table}, will be returned. If \code{FALSE} (default) the patients
at risk table is printed below the plot via \code{\link[cowplot:plot_grid]{cowplot::plot_grid()}}.}

\item{draw}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function no longer generates \code{grob} objects.}

\item{newpage}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function no longer generates \code{grob} objects.}

\item{gp}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function no longer generates \code{grob} objects.}

\item{vp}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function no longer generates \code{grob} objects.}

\item{name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This function no longer generates \code{grob} objects.}

\item{annot_coxph_ref_lbls}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{ref_lbls} element of
\code{control_annot_coxph} instead.}

\item{position_coxph}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}  Please use the \code{x} and \code{y} elements of
\code{control_annot_coxph} instead.}

\item{position_surv_med}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{x} and \code{y} elements of
\code{control_annot_surv_med} instead.}

\item{width_annots}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{w} element of \code{control_annot_surv_med}
(for \code{surv_med}) and \code{control_annot_coxph} (for \code{coxph})."}
}
\value{
A \code{ggplot} Kaplan-Meier plot and (optionally) summary table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

From a survival model, a graphic is rendered along with tabulated annotation
including the number of patient at risk at given time and the median survival
per group.
}
\examples{
library(dplyr)

df <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  mutate(is_event = CNSR == 0)
variables <- list(tte = "AVAL", is_event = "is_event", arm = "ARMCD")

# Basic examples
g_km(df = df, variables = variables)
g_km(df = df, variables = variables, yval = "Failure")

# Examples with customization parameters applied
g_km(
  df = df,
  variables = variables,
  control_surv = control_surv_timepoint(conf_level = 0.9),
  col = c("grey25", "grey50", "grey75"),
  annot_at_risk_title = FALSE,
  lty = 1:3,
  font_size = 8
)
g_km(
  df = df,
  variables = variables,
  annot_stats = c("min", "median"),
  annot_stats_vlines = TRUE,
  max_time = 3000,
  ggtheme = ggplot2::theme_minimal()
)

# Example with pairwise Cox-PH analysis annotation table, adjusted annotation tables
g_km(
  df = df, variables = variables,
  annot_coxph = TRUE,
  control_coxph = control_coxph(pval_method = "wald", ties = "exact", conf_level = 0.99),
  control_annot_coxph = control_coxph_annot(x = 0.26, w = 0.35),
  control_annot_surv_med = control_surv_med_annot(x = 0.8, y = 0.9, w = 0.35)
)

}
