% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blur.R
\name{blur}
\alias{blur}
\title{Gaussian blur of an array}
\usage{
blur(
  x,
  xmin = 0,
  xmax = 2^ceiling(log(max(x + 1), 2)) - 1,
  sigma = max(dim(x))/2^(length(dim(x)) + 1)
)
}
\arguments{
\item{x}{a numerical 'array' (including 'matrix')}

\item{xmin}{the smallest possible value in \code{x}; defaults to 0}

\item{xmax}{the largest possible value in \code{x}; defaults to the smallest
integer \eqn{2^k - 1 \leq \code{max(x)}}}

\item{sigma}{the standard deviation of the gaussian distribution with which
to convolve \code{x}; defaults to \eqn{\code{max(dim(x))} / 2^{D+1}}, where
\eqn{D} is the dimensionality of \code{x}}
}
\value{
An array of the same dimensions as \code{x}.
}
\description{
This function takes a numeric array of any dimension as input
and returns a blurred array of the same dimensions as output.
}
\details{
This function is adapted from \code{spatstat.explore::blur()}, part of
the \href{https://spatstat.org/}{spatstat package collection}.

The procedure takes the following steps:
\enumerate{
\item Rescale the value range
from \eqn{[\code{xmin},\code{xmax}]} to \eqn{[0,1]}.
\item Convolve \code{x} with \eqn{N(0,\code{sigma}^2)}.
\item Rescale the result back to the original value range.
}
}
\examples{
square <- matrix(byrow = TRUE, nrow = 6L, c(
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 1, 1, 1, 0, 0, 0,
  0, 1, 0, 0, 1, 1, 1, 0,
  0, 1, 0, 0, 1, 0, 1, 0,
  0, 1, 1, 1, 1, 1, 1, 0,
  0, 0, 0, 0, 0, 0, 0, 0
))
square_blur <- blur(square)
image(t(square))
image(t(square_blur))
}
