% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_allcurves.R
\name{plot_allcurves}
\alias{plot_allcurves}
\title{Plot All Curves Fit with tcplfit2_core - ggplot2}
\usage{
plot_allcurves(modelfits, conc, resp, log_conc = FALSE)
}
\arguments{
\item{modelfits}{Output from `tcplfit2_core`, contains resulting fits for all
models used to evaluate the observed concentration-response data.}

\item{conc}{Vector of concentrations (NOT in log units).}

\item{resp}{Vector of responses.}

\item{log_conc}{Logical argument. If `TRUE`, convert the concentrations (x-axis)
into log-10 scale. Defaults to `FALSE`.}
}
\value{
A `ggplot` object of the observed concentration-response data and
all resulting curve fits from `tcplfit2_core`. (Note: The constant model is
not included, and only the successful fits will be displayed.)
}
\description{
This function takes output from `tcplfit2_core` and generates a basic plot of
the observed concentration-response data with all resulting curve fits.
A `ggplot` object, which users may customize with additional `ggplot` layers,
is returned.
}
