% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratCI.R
\name{stratCI}
\alias{stratCI}
\title{stratCI: Estimate the confidence intervals of endpoints in
stratigraphic intervals}
\usage{
stratCI(times, method, nparams, C, endpoint, confidence, quantile)
}
\arguments{
\item{times}{a vector of occurrences in time for which we want to
estimate the endpoints of the stratigraphic interval}

\item{method}{a character describing which method to use, either
'Strauss-Sadler89' or 'Marshall94'.}

\item{nparams}{A character indicating whether to estimate one or two
parameters, possible values are 'one.par' and 'two.par'.}

\item{C}{numeric indicating the confidence level, e.g. 0.95}

\item{endpoint}{used only for nparams = 'one.par'. Possible values
are 'first' and 'last'.}

\item{confidence}{the confidence interval level, usually 0.95.}

\item{quantile}{the desired confidence level for a quantile representing
the brackets around the confidence interval.}
}
\value{
A named vector when using the 'Strauss-Sadler89' method, or
an unnamed vector when using the 'Marshall94' method.
}
\description{
stratCI: Estimate the confidence intervals of endpoints in
stratigraphic intervals
}
\details{
For method='Strauss-Sadler89' we need to provide
`nparams`, `C`, and `endpoint`. For method='Marshall94' we need to
provide `confidence` and `quantile`.
}
\examples{
data(andes)
andes <- andes$ages
# remove missing data
andes <- andes[complete.cases(andes)]
# remove outliers
andes <- sort(andes[which(andes < 10)])
stratCI(andes, method="Strauss-Sadler89",
        nparams="one.par", C=0.95, endpoint="first")
stratCI(andes, method="Strauss-Sadler89",
        nparams="one.par", C=0.95, endpoint="last")
stratCI(andes, method="Strauss-Sadler89",
        nparams="two.par", C=0.95)
stratCI(andes, method="Marshall94", confidence = 0.95,
        quantile = 0.8)
stratCI(andes, method="Marshall94", confidence = 0.95,
        quantile = 0.95)

}
\author{
Gustavo A. Ballen.
}
