% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/gnr_resolve.R
\name{gnr_resolve}
\alias{gnr_resolve}
\title{Resolve names using Global Names Resolver.}
\usage{
gnr_resolve(names, data_source_ids = NULL, resolve_once = FALSE,
  with_context = FALSE, stripauthority = FALSE, highestscore = TRUE,
  best_match_only = FALSE, preferred_data_sources = NULL, http = "get",
  callopts = list())
}
\arguments{
\item{names}{character; taxonomic names to be resolved. Doesn't work for verncular/common names.}

\item{data_source_ids}{character; IDs to specify what data source
is searched. See \code{\link[taxize]{gnr_datasources}}.}

\item{resolve_once}{logical; Find the first available match instead of
matches across all data sources with all possible renderings of a name.
When \code{TRUE}, response is rapid but incomplete.}

\item{with_context}{logical; Reduce the likelihood of matches to taxonomic
homonyms. When \code{TRUE} a common taxonomic context is calculated for
all supplied names from matches in data sources that have classification
tree paths. Names out of determined context are penalized during score
calculation.}

\item{stripauthority}{logical; If FALSE (default), gives back names with
taxonomic authorities. If TRUE, strips author names.}

\item{highestscore}{logical; Return those names with the highest score for
each searched name?}

\item{best_match_only}{(logical) If TRUE, best match only returned.}

\item{preferred_data_sources}{(character) A vector of one or more data source IDs.}

\item{http}{The HTTP method to use, one of "get" or "post". Default="get".
Use http="post" with large queries. Queries with > 300 records use "post"
automatically because "get" would fail}

\item{callopts}{Curl debugging options to pass in httr::GET or POST}
}
\value{
A data.frame.
}
\description{
Uses the Global Names Index, see \url{http://gni.globalnames.org/}.
}
\examples{
\dontrun{
gnr_resolve(names = c("Helianthus annuus", "Homo sapiens"))
gnr_resolve(names = c("Asteraceae", "Plantae"))

# Using data source 12 (Encyclopedia of Life)
sources <- gnr_datasources()
sources
eol <- sources$id[sources$title == 'EOL']
gnr_resolve(names=c("Helianthos annuus","Homo sapians"), data_source_ids=eol)

# Two species in the NE Brazil catalogue
sps <- c('Justicia brasiliana','Schinopsis brasiliensis')
gnr_resolve(names = sps, data_source_ids = 145)

# Best match only, compare the two
gnr_resolve(names = "Helianthus annuus", best_match_only = FALSE)
gnr_resolve(names = "Helianthus annuus", best_match_only = TRUE)

# Preferred data source
gnr_resolve(names = "Helianthus annuus", preferred_data_sources = c(3,4))

# Strip taxonomic authorities - default is stripauthority=FALSE
head(gnr_resolve(names = "Helianthus annuus")$results)
head(gnr_resolve(names = "Helianthus annuus", stripauthority=TRUE)$results)
}
}
\author{
Scott Chamberlain {myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{gnr_datasources}}
}
\keyword{names}
\keyword{resolve}
\keyword{taxonomy}

