% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_cue_force.R
\name{tar_cue_force}
\alias{tar_cue_force}
\title{Cue to force a target to run if a condition is true}
\usage{
tar_cue_force(
  condition,
  command = TRUE,
  depend = TRUE,
  format = TRUE,
  repository = TRUE,
  iteration = TRUE,
  file = TRUE
)
}
\arguments{
\item{condition}{Logical vector evaluated locally when the target is
defined. If any element of \code{condition} is \code{TRUE}, the target will
definitely rerun when the pipeline runs.
Otherwise, the target may or may not rerun, depending
on the other invalidation rules. \code{condition} is evaluated
when this cue factory is called, so the condition cannot
depend on upstream targets, and it should be quick to calculate.}

\item{command}{Logical, whether to rerun the target if command changed
since last time.}

\item{depend}{Logical, whether to rerun the target if the value of one
of the dependencies changed.}

\item{format}{Logical, whether to rerun the target if the user-specified
storage format changed. The storage format is user-specified through
\code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{repository}{Logical, whether to rerun the target if the user-specified
storage repository changed. The storage repository is user-specified
through \code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{iteration}{Logical, whether to rerun the target if the user-specified
iteration method changed. The iteration method is user-specified through
\code{\link[targets:tar_target]{tar_target()}} or \code{\link[targets:tar_option_set]{tar_option_set()}}.}

\item{file}{Logical, whether to rerun the target if the file(s) with the
return value changed or at least one is missing.}
}
\value{
A cue object. See the "Cue objects" section for background.
}
\description{
\code{tar_cue_force()} creates a cue object to
force a target to run if an arbitrary condition evaluates to \code{TRUE}.
Supply the returned cue object to the \code{cue} argument of
\code{targets::tar_target()} or similar.
}
\details{
\code{tar_cue_force()} and \code{\link[=tar_force]{tar_force()}} operate differently.
The former defines a cue object based on an eagerly evaluated
condition, and \code{\link[=tar_force]{tar_force()}} puts the condition in a special
upstream target that always runs. Unlike \code{tar_cue_force()},
the condition in \code{\link[=tar_force]{tar_force()}} can depend on upstream targets,
but the drawback is that targets defined with \code{\link[=tar_force]{tar_force()}}
will always show up as outdated in functions like \code{tar_outdated()}
and \code{tar_visnetwork()} even though \code{tar_make()} may still
skip the main target if the condition is not met.
}
\section{Cue objects}{

A cue object is an object generated by \code{targets::tar_cue()},
\code{tarchetypes::tar_cue_force()}, or similar. It is
a collection of decision rules that decide when a target
is invalidated/outdated (e.g. when \code{tar_make()} or similar
reruns the target). You can supply these cue objects to the
\code{tar_target()} function or similar. For example,
\code{tar_target(x, run_stuff(), cue = tar_cue(mode = "always"))}
is a target that always calls \code{run_stuff()} during \code{tar_make()}
and always shows as invalidated/outdated in \code{tar_outdated()},
\code{tar_visnetwork()}, and similar functions.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
targets::tar_script({
  library(tarchetypes)
  list(
    targets::tar_target(
      data,
      data.frame(x = seq_len(26)),
      cue = tarchetypes::tar_cue_force(1 > 0)
    )
  )
})
targets::tar_make()
targets::tar_make()
})
}
}
\seealso{
Other cues: 
\code{\link{tar_age}()},
\code{\link{tar_cue_age_raw}()},
\code{\link{tar_cue_age}()},
\code{\link{tar_cue_skip}()}
}
\concept{cues}
