% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_render_raw.R
\name{tar_render_raw}
\alias{tar_render_raw}
\title{Target with an R Markdown document (raw version).}
\usage{
tar_render_raw(
  name,
  path,
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  error = targets::tar_option_get("error"),
  deployment = "main",
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue"),
  quiet = TRUE,
  render_arguments = quote(list())
)
}
\arguments{
\item{name}{Character of length 1, name of the target.}

\item{path}{Character string, file path to the R Markdown source file.
Must have length 1.}

\item{packages}{Character vector of packages to load right before
the target builds. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{error}{Character of length 1, what to do if the target
runs into an error. If \code{"stop"}, the whole pipeline stops
and throws an error. If \code{"continue"}, the error is recorded,
but the pipeline keeps going. \code{error = "workspace"} is just like
\code{error = "stop"} except \code{targets} saves a special workspace file
to support interactive debugging outside the pipeline.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)}

\item{deployment}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
If \code{"main"}, the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
If \code{"worker"}, the worker loads the targets dependencies.}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{quiet}{An option to suppress printing during rendering from knitr,
pandoc command line and others. To only suppress printing of the last
"Output created: " message, you can set \code{rmarkdown.render.message} to
\code{FALSE}}

\item{render_arguments}{Optional language object with a list
of named arguments to \code{rmarkdown::render()}.
Cannot be an expression object.
(Use \code{quote()}, not \code{expression()}.)
The reason for quoting is that these arguments may depend on
upstream targets whose values are not available at
the time the target is defined, and because \code{tar_render_raw()}
is the "raw" version of a function, we want to avoid
all non-standard evaluation.}
}
\value{
A target object with \code{format = "file"}.
When this target runs, it returns a character vector
of file paths: the rendered document, the source file,
and then the \verb{*_files/} directory if it exists.
Unlike \code{rmarkdown::render()},
all returned paths are \emph{relative} paths to ensure portability
(so that the project can be moved from one file system to another
without invalidating the target).
See the "Target objects" section for background.
}
\description{
Shorthand to include an R Markdown document in a
\code{targets} pipeline (raw version)
}
\details{
\code{tar_render_raw()} is just like \code{tar_render()}
except that it uses standard evaluation. The \code{name} argument
is a character vector, and the \code{render_arguments} argument
is a language object.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({ # tar_dir() runs code from a temporary directory.
# Unparameterized R Markdown report:
lines <- c(
  "---",
  "title: 'report.Rmd source file'",
  "output_format: html_document",
  "---",
  "Assume these lines are in report.Rmd.",
  "```{r}",
  "targets::tar_read(data)",
  "```"
)
# Include the report in the pipeline as follows:
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_render_raw("report", "report.Rmd")
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.

# Parameterized R Markdown:
lines <- c(
  "---",
  "title: 'report.Rmd source file with parameters.'",
  "output_format: html_document",
  "params:",
  "  your_param: \"default value\"",
  "---",
  "Assume these lines are in report.Rmd.",
  "```{r}",
  "print(params$your_param)",
  "```"
)
# Include this parameterized report in the pipeline as follows.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_render_raw(
      "report",
      "report.Rmd",
      render_arguments = quote(list(params = list(your_param = data)))
    )
  )
}, ask = FALSE)
# Then, run the targets pipeline as usual.
})
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit_raw}()},
\code{\link{tar_knit}()},
\code{\link{tar_render_rep_raw}()},
\code{\link{tar_render_rep}()},
\code{\link{tar_render}()}
}
\concept{Literate programming targets}
