% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_tapnet.R
\name{simulate_tapnet}
\alias{simulate_tapnet}
\title{Creates a simulated along with all parameters, abundances, traits and phylogeny used}
\usage{
simulate_tapnet(
  nlower,
  nhigher,
  ntraits_nopem,
  ntraits_pem,
  pem_noise = 0.5,
  abuns = "lognormal",
  meanlog = 0,
  sdlog = 1,
  tmatch_type_pem = "normal",
  tmatch_type_obs = "normal",
  npems_lat = NULL,
  lat_low = 1,
  lat_high = 1,
  tmatch_width_pem = 1,
  pem_shift = 0,
  tmatch_width_obs = 1,
  Nwebs = 1,
  prop_species = 1,
  new_abuns = FALSE,
  Nobs = 1000
)
}
\arguments{
\item{nlower}{species number in lower trophic level;}

\item{nhigher}{species number in higher trophic level;}

\item{ntraits_nopem}{number of phylogenetically uncorrelated traits (for each level);}

\item{ntraits_pem}{number of phylogenetically correlated traits (for each level);}

\item{pem_noise}{noise (sd of normal dist) to put on PEMs;}

\item{abuns}{abundances set to "lognormal", "equal" or a list of two abundance vectors;}

\item{meanlog}{parameters of the log-normal distribution for drawing abundances;}

\item{sdlog}{same as before, but width;}

\item{tmatch_type_pem}{type of trait matching function for latent traits;}

\item{tmatch_type_obs}{type of trait matching function for observed traits (can be a vector as long as there are traits);}

\item{npems_lat}{number of phylogenetic eigenvectors to be used to construct latent traits. If NULL, all eigenvectors will be used;}

\item{lat_low}{vector of PEM linear combination parameters for lower trophic level; if 1, all values will be set to 1, if "random", values will be drawn from a uniform dist;}

\item{lat_high}{same for higher trophic level;}

\item{tmatch_width_pem}{width of trait matching function for latent (PEM-based) traits;}

\item{pem_shift}{shift parameter for latent trait matching;}

\item{tmatch_width_obs}{width of trait matching function for observed traits, can be a single value or a vector of length ntraits_nopem + ntraits_pem;}

\item{Nwebs}{number of webs to be simulated;}

\item{prop_species}{proportion of species in the phylogeny that appear in each web (species are drawn randomly). With multiple networks, this allows to create networks with partly overlapping species composition.}

\item{new_abuns}{If abuns = "lognormal" and Nwebs > 1, should new abundances be drawn for each web?}

\item{Nobs}{number of observed interactions per web}
}
\value{
A tapnet object, with a highly nested structure. There are six entries at the top level: trees, traits_all, networks, sim_params and the two tmatch types. Within networks, there is a list of 5 entries (for each of the \option{Nweb} networks): abundances, traits, PEMs, web and I_mat. "I_mat" is the actual output from simnetfromtap, while "web" is a single draw from a multinomial distribution with I_mat as probabilities and \option{Nobs} as size.
}
\description{
Simulation function to produce a tapnet object, i.e. one or more networks along with their descriptors, abundances, traits, phylogenetic information
}
\details{
This function was written to explore the fitting of networks by different methods. Hence, we first have to simulate such networks. It is a very nice starting point for simulations, but irrelevant for tapnet-based analyses. The function internally sets up all the parameters and then calls \code{\link{simnetfromtap}} for the simulation of the actual network. Lots of options means, regrettably, lots of decisions for the user.
}
\examples{
tapnet <- simulate_tapnet(nlower=10, nhigher=20, ntraits_nopem=2, ntraits_pem=0) 
# a minimal call of simulate_tapnet
str(tapnet, 1) # the structure at the first level
str(tapnet, 2) # the structure at the first and second level

}
\references{
Benadi et al. in prep
}
\author{
Gita Benadi <gita.benadi@biom.uni-freiburg.de>, Jochen Fründ <jochen.fruend@biom.uni-freiburg.de> and Carsten Dormann <carsten.dormann@biom.uni-freiburg.de>
}
