% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spherical_cal.R
\name{spherical_cal}
\alias{spherical_cal}
\title{Deduce the calibration constants}
\usage{
spherical_cal(X, n = NULL, method = NULL)
}
\arguments{
\item{X}{The segment of triaxial sensor data to calibrate. It must be a 3-column matrix. X can come from any triaxial field sensor and can be in any unit and any frame.}

\item{n}{The target field magnitude e.g., 9.81 for accelerometer data using m/s^2 as the unit.}

\item{method}{An optional string selecting the type of calibration. The default is to calibrate for offset and scaling only. Other options are: 'gain' adjust gain of axes 2 and 3 relative to 1, or 'cross' adjust gain and remove cross-axis correlations}
}
\value{
A list with 2 elements:
\itemize{
 \item{\strong{Y: }} The matrix of converted sensor values. These will have the same units as for input argument n. The size of Y is the same as the size of X and it has the same frame and sampling rate.
 \item{\strong{G: }} The calibration structure containing fields: G.poly is a matrix of polynomials. The first column of G.poly is the three scale factors applied to the columns of X. The second column is the offset added to each column of X after scaling. G.cross is a 3x3 matrix of cross-factors. If there are no cross-terms, this is the identity matrix. Off-axis terms correct for cross-axis sensitivity.
}
A message will also be printed to the screen presenting
}
\description{
This function is used to deduce the calibration constants for a triaxial field sensor, such as an accelerometer or magnetometer, based on movement data. This can be used to do a 'bench' calibration of a sensor.
}
\details{
The function reports the residual and the axial balance of the data.
A low residual e.g., <5\% indicates that the data can be calibrated
well and there is not much noise.
The axial balance indicates whether the movement in X is
suitable for data-driven calibration. If the movement covers all
directions fairly equally, the axial balance will be high.
A balance <20 \% may lead to unreliable calibration.
For bench calibrations, a high axial balance is achieved by
rotating the sensor through the full 3-dimensions.
Sampling rate and frame of Y are the same as the input data so
Y has the same size as X. The units of Y are the same as the units
used for n. If n is not specified, the units of Y are the same as
for the input data. It is a good idea to low-pass filter and/or
remove outliers from the sensor data before using this function
to reduce errors from specific acceleration and sensor noise.
}
\note{
This function uses a Simplex search for optimal calibration parameters and so can be slow if the data size is large.
For this reason it is most suitable for bench calibrations rather than
field data. This function is only usable for field sensors.
It will not work for gyroscope data.
}
\examples{
p <- spherical_cal(harbor_seal$A$data)

}
