% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/lib_Network_Evaluations.R
\name{default_clearing}
\alias{default_clearing}
\title{Clearing Vector with Bankruptcy Costs}
\usage{
default_clearing(L, ea, el = 0, alpha = 1, beta = 1)
}
\arguments{
\item{L}{Liabilities matrix}

\item{ea}{Vector of external assets}

\item{el}{Vector of external liabilites  (default 0)}

\item{alpha}{1-proportional default costs on external assets in [0,
1] (default to 1).}

\item{beta}{1-proportional default costs on interbank assets in [0,
1] (defaults to 1).}
}
\value{
A list consisting of a vector indicating which banks
default (1=default, 0= no default) and the greatest clearing
vector.
}
\description{
Computes bank defaults for the clearing vector approach without and
with bankruptcy costs (Eisenberg and Noe, 2001), (Rogers and Veraart, 2013).
}
\details{
Without bankruptcy costs the approach of Eisenberg and Noe (2001)
is used using a linear programme.  With bankruptcy costs, the
implementation is based on the Greatest Clearing Vector Algorithm (GA),
see Definition 3.6, Rogers & Veraart (2013).
}
\examples{
ea <- c(1/2,5/8,3/4)
el <- c(3/2,1/2,1/2)
x <- 0.5
L <- matrix(c(0,x,1-x,1-x,0,x,x,1-x,0),nrow=3)
default_clearing(L,ea,el)
default_clearing(L,ea,el, alpha=0.5, beta=0.7)
}
\references{
Eisenberg, L. and Noe, T.H. (2001). Systemic risk in financial
systems. Management Science 47, 236--249.

Rogers, L. C. G. and Veraart, L. A. M. (2013) Failure and Rescue in
an Interbank Network, Management Science 59 (4), 882--898.
}

