% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcp.R
\docType{data}
\name{pcp}
\alias{pcp}
\title{Daily precipitation grid of Balearic Islands (Spain)}
\format{
A data.frame with the following variables: \code{lon,lat,time,value}.
\describe{
  \item{geographical area:}{Balearic Islands}
  \item{time period:}{2000-01-01 to 2010-12-31}
  \item{units:}{mm*10}
  \item{coordinates reference system:}{+proj=utm +zone=30 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs}
}
}
\usage{
data(pcp)
}
\description{
Data from the SPREAD data set downloaded from the Spanish National Research Council (CSIC).
(\url{http://spread.csic.es/info.html}).
This data corresponds to daily values of precipitation with a spatial resolution of 5 x 5 km from January 2000 to december 2010
}
\examples{
data(pcp)
}
\references{
Serrano-Notivoli et al. (2017)
\emph{SPREAD: a high-resolution daily gridded precipitation dataset for Spain, an extreme events frequency and intensity overview.
             Earth Syst. Sci. Data, 9, 721-738, 2017, https://doi.org/10.5194/essd-9-721-2017}
}
\keyword{datasets}
